#ifndef __SUBNETTREE_H__
#define __SUBNETTREE_H__

#include "Interfaces/cObject.h"
class cEndpoint;

//
// CAUTION: There is *no* locking on this class.


class cSubnetTree;

typedef struct SubnetInfo
{
	cEndpoint* subnet;
	cEndpoint* lastGossipOnSubnet;
} SubnetInfo;

// Iterator over the subnet tree.
class cSubnetTreeIterator : public cIterator
{
  public:
	cSubnetTreeIterator(cSubnetTree* tree) { mTree = tree; mIndex = 0; }
	cSubnetTreeIterator() { ; }
	bool		Done();
	cObject*	GetData();
	bool		GetNext();
	bool		DeleteCurrent();
	
  private:
	cSubnetTree*	mTree;
	unsigned int	mIndex;
};

class cSubnetTree
{

 protected:

 public:
	friend class cSubnetTreeIterator;
	
	//Constructor(s)
	cSubnetTree(unsigned int initialCap, unsigned int capInc);	

	//Destructor
	~cSubnetTree();

	//Public Functions
	bool	Clear();				// Clears the tree.
	int		GetNumElements()  { return mInsertPtr; }

	bool		 Delete(cEndpoint* subnet);					// Removes that subnet from the array
	bool		 Insert(cEndpoint* subnet);					// Inserts the subnet into the array (in sorted order)
	int			 Find(cEndpoint* subnet);					// returns index of given subnet (-1 if fail).

	bool		 UpdateGossip(cEndpoint* gossipPartner);	// Updates the lastGossipOnSubnet of the given subnet.

	bool		 GetRandomSubnet(SubnetInfo* info, unsigned int* rootIndex);
	cEndpoint*	 GetRandomSubnet();
	int			 GetChild(unsigned int rootIndex, unsigned int currentIndex, unsigned int childNum, unsigned int fanout);
	SubnetInfo	 GetSubnetInfo(unsigned int index) { return mQueue[index]; }
	cIterator*	 GetIterator() { mIter = cSubnetTreeIterator(this); return &mIter; }

	unsigned int GetHeight(unsigned int fanout);

 private:
	int	 _BinSearch(cEndpoint* subnet, int left, int right);
	bool _Before(cEndpoint* a, cEndpoint* b);
	bool _Equal(cEndpoint* a, cEndpoint* b);
	bool _InsertSort();
	bool _Grow();		// Attempts to grow the queue by at least one element, at most mCapIncrement

	//Member Vars
	SubnetInfo	*mQueue;
	unsigned int mInsertPtr;
	unsigned int mSize;
	unsigned int mCapIncrement;
	cSubnetTreeIterator mIter;
};

#endif
